<?php 
	error_reporting(E_ALL);
	ini_set('display_errors', 1);
	ini_set('max_execution_time', 1200);
	
	include '../inc/config.php';
	include '../inc/functions.php';
	
	$ip = getIP();
	
	if(!in_array($ip, $allowed_ips)){
		show_error_and_log($logfolder, "getLeerlingenJson opgevraagd vanuit niet toegelaten IP $ip");
		exit;
	}
	
	if(!isset($_GET['session_hash']) || strlen($_GET['session_hash']) != 64){
		show_error_and_log($logfolder, "getLeerlingenJson opgevraagd vanuit toegelaten IP $ip maar zonder (geldige) session_hash");
		exit;
	}
	
	
	if(!isset($_GET['lerarenid']) || !is_numeric($_GET['lerarenid'])){
		show_error_and_log($logfolder, "getLeerlingenJson opgevraagd vanuit toegelaten IP $ip maar zonder (geldige) lerarenid");
		exit;
	}	

	$session_hash = $_GET['session_hash']; 
	$lerarenid	  = $_GET['lerarenid'];
	
	$verify_url = $toolbox_url.'/public/validate_ad_leerlingen_bs.php?session_hash='.$session_hash.'&key='.$ad_key;

	$return = file_get_contents($verify_url);
	log_to_file($logfolder, "Return van validate_ad_leerlingen: $return");	
	$return = json_decode($return);
		
	if(!is_object($return)){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen object)");
		exit;
	}
	
	if(!property_exists($return, 'lerarenid')){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid)");
		exit;
	}				
						
	if($return->lerarenid != $lerarenid){					
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid)");
		exit;
	}						
						
						
	if(!property_exists($return, 'ad_leerlingen_default_ou')){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen ad_leerlingen_default_ou)");
		exit;
	}	
	
	$zoek_genest = 'true';
	if(property_exists($return, 'zoek_genest')){
		$zoek_genest = $return->zoek_genest;
	}
	
	log_to_file($logfolder, "Genest zoeken: $zoek_genest");
				
	$arr_data = array();
	
	// Default OU uitlezen
	// ====================
		$ou = $return->ad_leerlingen_default_ou;
		$arr_default_ou_data = array();
		
		exec("powershell -command C:\\toolbox\\powershell\\getADLeerlingenJson.ps1 -ou '$ou' -zoekgenest '$zoek_genest'",$arr_default_ou_data);
		
		if(!is_array($arr_default_ou_data)){	
			show_error_and_log($logfolder, "Geen array teruggekregen vanuit de AD");
			exit;
		}
		
		if (!empty($arr_default_ou_data)) {
			if(substr($arr_default_ou_data[0], 0, 4) == 'Fout'){
				show_error_and_log($logfolder, $arr_default_ou_data[0]);
				exit;
			}
		}
	
		// json omzetten naar array en toevoegen aan output array $arr_data
			$arr_data = json_decode(implode('', $arr_default_ou_data));		
	
	
	// OU op basis van instellingsnummers uitlezen
	// ============================================
		if(property_exists($return, 'bijkomende_ou_instellingsnummers')){
			if(is_array($return->bijkomende_ou_instellingsnummers)){
				foreach($return->bijkomende_ou_instellingsnummers as $bijkomende_ou){
					if($bijkomende_ou != ''){
						$arr_data_ou_inst = array();
						exec("powershell -command C:\\toolbox\\powershell\\getADLeerlingenJson.ps1 -ou '$bijkomende_ou' -zoekgenest '$zoek_genest'", $arr_data_ou_inst);

						if(is_array($arr_data_ou_inst) && count($arr_data_ou_inst)>0){
							if(substr($arr_data_ou_inst[0], 0, 4) == 'Fout'){
								show_error_and_log($logfolder, $arr_data_ou_inst[0]);
								exit;
							}
							else{
								$arr_data_ou_inst = json_decode(implode($arr_data_ou_inst));
								
								if(is_object($arr_data_ou_inst)){
									$arr_data[] = $arr_data_ou_inst;
								}
								else{
									foreach($arr_data_ou_inst as $data_ou_inst){
										$arr_data[] = $data_ou_inst;
									}
								}
							}
						}
					}
				}
			}
		}
		
		
	// OU op basis van klassen uitlezen
	// ============================================
		if(property_exists($return, 'bijkomende_ou_klassen')){
			if(is_array($return->bijkomende_ou_klassen)){
				foreach($return->bijkomende_ou_klassen as $bijkomende_ou){
					if($bijkomende_ou != ''){
						$arr_data_ou_klassen = array();
						exec("powershell -command C:\\toolbox\\powershell\\getADLeerlingenJson.ps1 -ou '$bijkomende_ou' -zoekgenest '$zoek_genest'", $arr_data_ou_klassen);
						
						
						if(is_array($arr_data_ou_klassen) && count($arr_data_ou_klassen)>0){
							
							if(substr($arr_data_ou_klassen[0], 0, 4) == 'Fout'){
								show_error_and_log($logfolder, $arr_data_ou_klassen[0]);
								exit;
							}
							else{
								$arr_data_ou_klassen = json_decode(implode($arr_data_ou_klassen));
								
								if(is_object($arr_data_ou_klassen)){
									$arr_data[] = $arr_data_ou_klassen;
								}
								else{
									foreach($arr_data_ou_klassen as $data_ou_inst){
										$arr_data[] = $data_ou_inst;
									}
								}
							}
						}
					}
				}
			}
		}	
		
	
	// Log
		log_to_file($logfolder, "Output van getLeerlingenJson (AD) verzonden naar $ip");
	
	// Output
		echo json_encode($arr_data);


?>